unit linkexpert ;

interface

uses ShellAPI, Windows, Dialogs, ExptIntf ;

type
    TGLDelphiLinksExpert = class(TIExpert)
    public
       procedure Execute ; override ;
       function GetAuthor : string ; override ;
       function GetComment : string ; override ;
       function GetGlyph : HICON ; override ;
       function GetIDString : string ; override ;
       function GetMenuText : string ; override ;
       function GetName : string ; override ;
       function GetPage : string ; override ;
       function GetState : TExpertState ; override ;
       function GetStyle : TExpertStyle ; override ;
    end ;

implementation

uses LinkDialog ;

{ TGLDelphiLinksExpert }

procedure TGLDelphiLinksExpert.Execute;
begin
     DisplayLinkDialog ;
end;

function TGLDelphiLinksExpert.GetAuthor: string;
begin
     Result := 'Greg Lief' ;
end;

function TGLDelphiLinksExpert.GetComment: string;
begin
     Result := 'Greg Lief''s Delphi Links expert' ;
end;

// icons only apply to project or form experts
function TGLDelphiLinksExpert.GetGlyph: HICON;
begin
     Result := 0 ;
end;

// global unique identifier for this expert
function TGLDelphiLinksExpert.GetIDString: string;
begin
     Result := 'GregLiefDelphiLinks.Expert' ;
end;

// menu label for Delphi's help menu.  In a real
// expert, you should load the string from a resource.
// Note that the stock D4 Help menu reserves the
// following trigger letters: A, C, I, N, P, R, S, T
function TGLDelphiLinksExpert.GetMenuText: string;
begin
     Result := 'Delphi &Links' ;
end;

function TGLDelphiLinksExpert.GetName: string;
begin
     Result := 'Greg Lief Delphi Links Expert' ;
end;

// name of page in object repository (only applies to form/project experts)
function TGLDelphiLinksExpert.GetPage: string;
begin
     Result := '' ;
end;

// state of menu item (options include esEnabled and esChecked)
function TGLDelphiLinksExpert.GetState: TExpertState;
begin
     Result := [esEnabled] ;
end;

// type of expert (esProject, esForm, esStandard, or esAddIn)
function TGLDelphiLinksExpert.GetStyle: TExpertStyle;
begin
     Result := esStandard ;
end;

end.
